/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.mojang.math.Vector3f;
import com.tiviacz.pizzacraft.blockentity.BaseBlockEntity;
import com.tiviacz.pizzacraft.blockentity.content.BasinContent;
import com.tiviacz.pizzacraft.blockentity.content.BasinContentType;
import com.tiviacz.pizzacraft.blockentity.content.SauceType;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.ModTags;
import com.tiviacz.pizzacraft.recipes.crushing.CrushingRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BasinBlockEntity
extends BaseBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private BasinContent content = BasinContent.AIR;
    private ItemStack squashedStack = ItemStack.f_41583_;
    private int fermentProgress = 0;
    private final int defaultFermentTime = 1200;
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private final String BASIN_CONTENT = "BasinContent";
    private final String SQUASHED_STACK = "SquashedStack";
    private final String FERMENT_PROGRESS = "FermentProgress";
    private int tick = 0;

    public BasinBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BASIN.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.content = BasinContent.BasinContentRegistry.REGISTRY.fromString(compound.m_128461_("BasinContent"));
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.squashedStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SquashedStack"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("BasinContent", this.content.toString());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag squashedStack = new CompoundTag();
        this.squashedStack.m_41739_(squashedStack);
        compound.m_128365_("SquashedStack", (Tag)squashedStack);
    }

    public float getAmount() {
        return (float)this.getSquashedStackCount() * 0.75f;
    }

    public BasinContent getBasinContent() {
        if (this.content == null) {
            return BasinContent.FERMENTING_MILK;
        }
        return this.content;
    }

    public void updateBasinContent() {
        if (this.getSquashedStackCount() <= 0) {
            this.squashedStack = ItemStack.f_41583_;
            this.content = BasinContent.AIR;
        }
        this.m_6596_();
    }

    public static Map<BasinContent, ItemStack> basinContentToItemStack() {
        HashMap map = Maps.newHashMap();
        map.put(BasinContent.AIR, ItemStack.f_41583_);
        map.put(BasinContent.MILK, ItemStack.f_41583_);
        map.put(BasinContent.FERMENTING_MILK, ItemStack.f_41583_);
        map.put(BasinContent.CHEESE, new ItemStack((ItemLike)ModBlocks.CHEESE_BLOCK.get()));
        map.put(BasinContent.TOMATO_SAUCE, new ItemStack((ItemLike)ModItems.TOMATO_SAUCE.get()));
        map.put(BasinContent.OLIVE_OIL, new ItemStack((ItemLike)ModItems.OLIVE_OIL.get()));
        return map;
    }

    public static Map<BasinContent, Integer> basinContentExtractSize() {
        HashMap map = Maps.newHashMap();
        map.put(BasinContent.AIR, 999);
        map.put(BasinContent.MILK, 999);
        map.put(BasinContent.FERMENTING_MILK, 999);
        map.put(BasinContent.CHEESE, 1);
        map.put(BasinContent.TOMATO_SAUCE, 4);
        map.put(BasinContent.OLIVE_OIL, 4);
        return map;
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand) {
        ItemStack itemHeld = player.m_21120_(hand);
        BasinContentType basinContentType = this.getBasinContent().getContentType();
        ItemStack stackInSlot = this.getInventory().getStackInSlot(0);
        if (basinContentType == BasinContentType.CHEESE) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, new ItemStack((ItemLike)ModBlocks.CHEESE_BLOCK.get())));
            this.content = BasinContent.AIR;
            this.squashedStack = ItemStack.f_41583_;
            this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12132_, SoundSource.BLOCKS, 0.8f, 0.9f + this.f_58857_.f_46441_.m_188501_());
            this.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            if (basinContentType == BasinContentType.MILK) {
                if (itemHeld.m_204117_(ModTags.FERMENTING_ITEMS_TAG)) {
                    this.content = BasinContent.FERMENTING_MILK;
                    this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        itemHeld.m_41774_(1);
                    }
                    this.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (itemHeld.m_41720_() instanceof BucketItem) {
                    this.content = BasinContent.AIR;
                    itemHeld.m_41774_(1);
                    if (!player.m_36356_(new ItemStack((ItemLike)Items.f_42455_))) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(player.f_19853_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), new ItemStack((ItemLike)Items.f_42455_)));
                    }
                    this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 0.8f, 1.0f);
                    this.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            }
            if (basinContentType == BasinContentType.EMPTY || this.getBasinContent().getSauceType() != SauceType.NONE || basinContentType == BasinContentType.OIL) {
                if (basinContentType == BasinContentType.EMPTY) {
                    if (itemHeld.m_41720_() == ModItems.CHEESE_BLOCK.get() && stackInSlot.m_41619_()) {
                        this.content = BasinContent.CHEESE;
                        this.squashedStack = new ItemStack((ItemLike)ModItems.CHEESE.get(), this.getInventory().getSlotLimit(0));
                        if (!player.m_7500_()) {
                            itemHeld.m_41774_(2);
                        }
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12132_, SoundSource.BLOCKS, 0.8f, 0.9f + this.f_58857_.f_46441_.m_188501_());
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                    if (itemHeld.m_41720_() instanceof MilkBucketItem && stackInSlot.m_41619_()) {
                        this.content = BasinContent.MILK;
                        this.squashedStack = new ItemStack((ItemLike)Items.f_42455_, this.getInventory().getSlotLimit(0));
                        if (!player.m_7500_()) {
                            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                        }
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.8f, 1.0f);
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                    if (this.canInsert(itemHeld)) {
                        this.insertStack(player, hand);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.canExtract(player, hand)) {
                        this.extractStack(player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (this.getBasinContent().getSauceType() != SauceType.NONE || basinContentType == BasinContentType.OIL) {
                    if (this.getSquashedStackCount() >= BasinBlockEntity.basinContentExtractSize().get((Object)this.getBasinContent())) {
                        ItemStack result = BasinBlockEntity.basinContentToItemStack().get((Object)this.getBasinContent());
                        if (!player.m_150109_().m_36054_(result)) {
                            this.f_58857_.m_7967_((Entity)new ItemEntity(player.f_19853_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), result));
                        }
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 0.7f, 0.9f + this.f_58857_.f_46441_.m_188501_());
                        this.setSquashedStackCount(this.getSquashedStackCount() - BasinBlockEntity.basinContentExtractSize().get((Object)this.getBasinContent()));
                        return InteractionResult.SUCCESS;
                    }
                    if (this.canInsert(itemHeld)) {
                        this.insertStack(player, hand);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.canExtract(player, hand)) {
                        this.extractStack(player);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public ItemStack getSquashedStack() {
        return this.squashedStack;
    }

    public int getSquashedStackCount() {
        return this.squashedStack.m_41613_();
    }

    public void setSquashedStackCount(int count) {
        this.squashedStack.m_41764_(count);
        this.updateBasinContent();
    }

    public void crush(Player player) {
        if (!this.isEmpty((IItemHandlerModifiable)this.inventory) && this.getSquashedStackCount() + 1 <= this.getInventory().getSlotLimit(0)) {
            ItemStack stack = this.getInventory().getStackInSlot(0);
            Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)CrushingRecipe.Type.CRUSHING_RECIPE_TYPE, (Container)new RecipeWrapper(this.getInventory()), this.f_58857_);
            if (match.isPresent()) {
                if (BasinContent.BasinContentRegistry.REGISTRY.fromString(((CrushingRecipe)match.get()).getContentOutput()) == null) {
                    throw new JsonSyntaxException(String.format("Content in %s recipe does not exist", match.get()));
                }
                if (this.getBasinContent() == BasinContent.AIR || this.getBasinContent() == BasinContent.BasinContentRegistry.REGISTRY.fromString(((CrushingRecipe)match.get()).getContentOutput())) {
                    if (this.getSquashedStack().m_41619_()) {
                        this.squashedStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
                    } else {
                        this.setSquashedStackCount(this.getSquashedStackCount() + 1);
                    }
                    this.content = BasinContent.BasinContentRegistry.REGISTRY.fromString(((CrushingRecipe)match.get()).getContentOutput());
                    this.decrStackSize((IItemHandlerModifiable)this.inventory, 0, 1);
                    this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12390_, SoundSource.BLOCKS, 0.7f, 0.9f + 0.1f * this.f_58857_.f_46441_.m_188501_());
                }
            }
        }
    }

    public int getFermentProgress() {
        return this.fermentProgress;
    }

    public int getDefaultFermentTime() {
        return this.defaultFermentTime;
    }

    public int getComparatorOutput() {
        float f = (float)this.fermentProgress / 1200.0f;
        return (int)(f * 15.0f);
    }

    public void finishFermenting() {
        if (this.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
            this.fermentProgress = 0;
            this.content = BasinContent.CHEESE;
        }
        this.m_6596_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (this.getBasinContent() == BasinContent.FERMENTING_MILK) {
            this.fermentProgress = tag.m_128451_("FermentProgress");
        } else {
            super.handleUpdateTag(tag);
        }
    }

    @Override
    public CompoundTag m_5995_() {
        if (this.getBasinContent() == BasinContent.FERMENTING_MILK) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("FermentProgress", this.fermentProgress);
            return tag;
        }
        return super.m_5995_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BasinBlockEntity blockEntity) {
        if (blockEntity.getBasinContent() != null) {
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.FERMENTING_MILK) {
                ++blockEntity.fermentProgress;
                if (blockEntity.fermentProgress % 60 == 0) {
                    level.m_5594_(null, pos, SoundEvents.f_12132_, SoundSource.BLOCKS, 0.8f, 0.9f + level.f_46441_.m_188501_());
                }
            }
            if (blockEntity.fermentProgress >= blockEntity.defaultFermentTime) {
                blockEntity.finishFermenting();
            }
            if (blockEntity.getBasinContent().getContentType() == BasinContentType.CHEESE) {
                if (blockEntity.tick % 20 == 0) {
                    blockEntity.createCheeseParticle();
                }
                if (blockEntity.tick < 60) {
                    ++blockEntity.tick;
                } else if (blockEntity.tick == 60) {
                    blockEntity.tick = 0;
                }
            }
        }
    }

    private void createCheeseParticle() {
        double x = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        double z = (double)this.f_58857_.f_46441_.m_188503_(12) / 16.0;
        this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.91f, 0.76f, 0.31f), 1.0f), (double)this.m_58899_().m_123341_() + x + 0.2, (double)this.m_58899_().m_123342_() + 0.6, (double)this.m_58899_().m_123343_() + z + 0.2, 0.0, 0.09, 0.0);
    }

    public boolean isEmpty() {
        return this.getInventory().getStackInSlot(0).m_41619_();
    }

    public boolean canInsert(ItemStack stack) {
        return !stack.m_41619_() && this.isEmpty();
    }

    public boolean canExtract(Player player, InteractionHand handIn) {
        return player.m_21120_(handIn).m_41619_() && !this.isEmpty();
    }

    public void insertStack(Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            player.m_21008_(hand, this.getInventory().insertItem(0, player.m_21120_(hand), false));
        } else {
            this.getInventory().insertItem(0, player.m_21120_(hand).m_41777_(), false);
        }
        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
    }

    public void extractStack(Player player) {
        if (!player.m_7500_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.getInventory().extractItem(0, 64, false));
        } else {
            this.getInventory().extractItem(0, 64, false);
        }
        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 8;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BasinBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

